/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.auimlcvt.auiml.formatters;

import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmDataFormatter;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.ValidationException;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.NullContextException;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class TimeFormatter
implements PmDataFormatter {
    protected static final String RESOURCE_BUNDLE = "com.ibm.hwmca.fw.util.auimlcvt.auiml.formatters.res.formatter";
    private static final String TRACE_MASKD = "XFMTTIMD";
    private static final String TRACE_MASKF = "XFMTTIMF";
    private static final String TRACE_MASKT = "XFMTTIMT";

    public String format(Object rawObject) {
        Trace.trace(TRACE_MASKT, "TimeFormatter.format('" + rawObject + "')");
        if (rawObject instanceof Calendar) {
            DateFormat format;
            Date time = ((Calendar)rawObject).getTime();
            try {
                ClientUserContext userContext = ClientUserContext.getUserContext();
                format = DateFormat.getTimeInstance(2, userContext.getLocale());
                format.setTimeZone(userContext.getTimeZone());
            }
            catch (NullContextException e) {
                format = DateFormat.getTimeInstance();
            }
            return format.format(time);
        }
        Trace.trace(TRACE_MASKF, "TimeFormatter.format() - rawObject was not a Calendar!");
        return "";
    }

    public Object parse(Object source) throws ValidationException {
        Trace.trace(TRACE_MASKT, "TimeFormatter.parse(" + source + ")");
        if (source instanceof String) {
            try {
                Calendar calendar;
                DateFormat format;
                try {
                    ClientUserContext userContext = ClientUserContext.getUserContext();
                    format = DateFormat.getTimeInstance(2, userContext.getLocale());
                    format.setTimeZone(userContext.getTimeZone());
                    calendar = Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale());
                }
                catch (NullContextException e) {
                    format = DateFormat.getTimeInstance();
                    calendar = Calendar.getInstance();
                }
                Date time = format.parse((String)source);
                calendar.setTime(time);
                return calendar;
            }
            catch (ParseException pe) {
                Trace.trace(TRACE_MASKF, "TimeFormatter.format() - Exception during parse! - " + pe.getMessage());
                throw new ValidationException(new MessageText(RESOURCE_BUNDLE, "TimeFailedToParse", new Object[]{source}));
            }
        }
        Trace.trace(TRACE_MASKF, "TimeFormatter.format() - source was not a String!");
        return null;
    }
}

